/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.DefaultButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class PopupButton
extends JButton {
    private Dimension preferredSize;
    private Dimension referenceSize;
    private JPopupMenu popupMenu;
    private JRadioButtonMenuItem selectedItem;
    private PopupButtonListener listener;
    private PopupButtonModel model;
    private ImageIcon[] icons;
    private String[] labels;

    public PopupButton(String[] stringArray, ImageIcon[] imageIconArray) {
        super(stringArray[0], imageIconArray[0]);
        this.labels = stringArray;
        this.icons = imageIconArray;
        if (stringArray.length > 1) {
            this.model = new PopupButtonModel();
            this.listener = new PopupButtonListener();
            this.addMouseMotionListener(this.listener);
            this.setModel(this.model);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.isShiftDown() && (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40)) {
                        PopupButton.this.showPopupMenu();
                    }
                }
            });
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = this.computePreferredSize();
        if (dimension != null) {
            return dimension;
        }
        return super.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.computePreferredSize();
        if (dimension != null) {
            return dimension;
        }
        return super.getPreferredSize();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.labels.length > 1 && this.model.isRollover() && !this.model.isPressed()) {
            Rectangle rectangle = this.getPopupBounds();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
            graphics.setColor(this.model.isPressed() && this.model.isArmed() || this.model.isSelected() ? Color.GRAY : Color.LIGHT_GRAY);
            graphics.drawLine(rectangle.x, rectangle.y + 1, rectangle.x, rectangle.y + rectangle.height - 2);
            this.drawPopupArrow(graphics, rectangle.x + 4, rectangle.y + rectangle.height / 2 - 1);
        }
    }

    public void showPopupMenu() {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        jPopupMenu.show(this, 0, this.getSize().height - 1);
    }

    private Rectangle getButtonBounds() {
        return new Rectangle(0, 0, this.getSize().width, this.getSize().height);
    }

    private Rectangle getPopupBounds() {
        Rectangle rectangle = this.getButtonBounds();
        return new Rectangle(rectangle.x + rectangle.width - 15, rectangle.y, 15, rectangle.height);
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)actionEvent.getSource();
                    if (PopupButton.this.selectedItem != jRadioButtonMenuItem) {
                        PopupButton.this.selectedItem.setSelected(false);
                    }
                    jRadioButtonMenuItem.setSelected(true);
                    PopupButton.this.selectedItem = jRadioButtonMenuItem;
                    PopupButton.this.setText(jRadioButtonMenuItem.getText());
                    if (PopupButton.this.icons.length > 1) {
                        PopupButton.this.setIcon(PopupButton.this.icons[PopupButton.this.getPopupMenu().getComponentIndex(jRadioButtonMenuItem)]);
                    }
                    PopupButton.this.firePopupAction();
                }
            };
            JPopupMenu jPopupMenu = new JPopupMenu();
            for (int i = 0; i < this.labels.length; ++i) {
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(this.labels[i], i == 0);
                if (i == 0) {
                    this.selectedItem = jRadioButtonMenuItem;
                }
                jRadioButtonMenuItem.addActionListener(actionListener);
                jPopupMenu.add(jRadioButtonMenuItem);
            }
            this.popupMenu = jPopupMenu;
        }
        return this.popupMenu;
    }

    private Dimension computePreferredSize() {
        if (this.labels.length > 1 && this.referenceSize != super.getPreferredSize()) {
            JButton jButton = new JButton(this.labels[0], this.icons[0]);
            jButton.setFont(this.getFont());
            jButton.setBorder(this.getBorder());
            jButton.setMargin(this.getMargin());
            jButton.setContentAreaFilled(this.isContentAreaFilled());
            jButton.setVerticalTextPosition(this.getVerticalTextPosition());
            jButton.setHorizontalTextPosition(this.getHorizontalTextPosition());
            this.preferredSize = new Dimension(jButton.getPreferredSize());
            if (this.labels.length > 1) {
                for (int i = 1; i < this.labels.length; ++i) {
                    jButton.setText(this.labels[i]);
                    if (this.icons.length > 1) {
                        jButton.setIcon(this.icons[i]);
                    }
                    this.preferredSize.width = Math.max(this.preferredSize.width, jButton.getPreferredSize().width);
                    this.preferredSize.height = Math.max(this.preferredSize.height, jButton.getPreferredSize().height);
                }
            }
            this.referenceSize = super.getPreferredSize();
        }
        return this.preferredSize;
    }

    private void drawPopupArrow(Graphics graphics, int n, int n2) {
        graphics.setColor(this.listener.isOverPopupArea() ? Color.DARK_GRAY : Color.GRAY);
        if (this.model.isPopupAreaPressed()) {
            ++n;
            ++n2;
        }
        graphics.drawLine(n + 0, n2 + 0, n + 6, n2 + 0);
        graphics.drawLine(n + 1, n2 + 1, n + 5, n2 + 1);
        graphics.drawLine(n + 2, n2 + 2, n + 4, n2 + 2);
        graphics.drawLine(n + 3, n2 + 3, n + 3, n2 + 3);
    }

    private void firePopupAction() {
        int n = 0;
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        if (aWTEvent instanceof InputEvent) {
            n = ((InputEvent)aWTEvent).getModifiers();
        } else if (aWTEvent instanceof ActionEvent) {
            n = ((ActionEvent)aWTEvent).getModifiers();
        }
        this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), n));
    }

    private class PopupButtonModel
    extends DefaultButtonModel {
        private boolean popupAreaPressed;

        private PopupButtonModel() {
        }

        public void setPopupAreaPressed(boolean bl) {
            this.popupAreaPressed = bl;
        }

        public boolean isPopupAreaPressed() {
            return this.popupAreaPressed;
        }

        @Override
        public void setPressed(boolean bl) {
            if (!bl) {
                boolean bl2 = this.isPopupAreaPressed() && this.isArmed() && PopupButton.this.listener.isOverPopupArea();
                this.setPopupAreaPressed(bl);
                super.setPressed(bl);
                if (bl2) {
                    PopupButton.this.showPopupMenu();
                }
            } else if (PopupButton.this.listener.isOverPopupArea()) {
                this.setPopupAreaPressed(bl);
            } else {
                super.setPressed(bl);
            }
        }
    }

    private class PopupButtonListener
    extends MouseMotionAdapter {
        private boolean overPopupArea;

        private PopupButtonListener() {
        }

        public boolean isOverPopupArea() {
            return this.overPopupArea;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseMoved(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            boolean bl = PopupButton.this.getPopupBounds().contains(mouseEvent.getPoint());
            if (this.overPopupArea != bl) {
                this.overPopupArea = bl;
                PopupButton.this.repaint();
            }
        }
    }
}

