/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public final class RerunAction
extends CallableSystemAction
implements ProfilingStateListener {
    private boolean lastState = false;

    public RerunAction() {
        this.putProperty("ShortDescription", NbBundle.getMessage(RerunAction.class, (String)"HINT_RerunAction"));
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
    }

    public boolean isEnabled() {
        if (!NetBeansProfiler.isInitialized()) {
            return false;
        }
        this.lastState = Profiler.getDefault().rerunAvailable();
        return this.lastState;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage(RerunAction.class, (String)"LBL_RerunAction");
    }

    public void instrumentationChanged(int n, int n2) {
    }

    public void performAction() {
        int n = Profiler.getDefault().getProfilingState();
        int n2 = Profiler.getDefault().getProfilingMode();
        if (n == 8 || n == 4) {
            if (n2 == 1) {
                if (!ProfilerDialogs.displayConfirmation((String)NbBundle.getMessage(RerunAction.class, (String)"MSG_ReRunOnProfile"), (String)NbBundle.getMessage(RerunAction.class, (String)"CAPTION_Question"))) {
                    return;
                }
                Profiler.getDefault().stopApp();
            } else {
                if (!ProfilerDialogs.displayConfirmation((String)NbBundle.getMessage(RerunAction.class, (String)"MSG_ReRunOnAttach"), (String)NbBundle.getMessage(RerunAction.class, (String)"CAPTION_Question"))) {
                    return;
                }
                Profiler.getDefault().detachFromApp();
            }
        }
        Profiler.getDefault().rerunLastProfiling();
    }

    public void profilingStateChanged(ProfilingStateEvent profilingStateEvent) {
        this.updateAction();
    }

    public void threadsMonitoringChanged() {
    }

    public void updateAction() {
        if (this.lastState != Profiler.getDefault().rerunAvailable()) {
            boolean bl = this.isEnabled();
            this.firePropertyChange("enabled", !bl, bl);
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    protected String iconResource() {
        return Icons.getResource((String)"GeneralIcons.Rerun");
    }
}

