/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.internal.toolkit.builders;

import com.javafx.tools.doclets.internal.toolkit.ClassWriter;
import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.LayoutParser;
import com.javafx.tools.doclets.internal.toolkit.builders.XMLNode;
import com.javafx.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;

public class ClassBuilder
extends AbstractBuilder {
    public static final String ROOT = "ClassDoc";
    private ClassDoc classDoc;
    private ClassWriter writer;
    private boolean isInterface = false;
    private boolean isEnum = false;
    private Content contentTree;

    private ClassBuilder(Configuration configuration) {
        super(configuration);
    }

    public static ClassBuilder getInstance(Configuration configuration, ClassDoc classDoc, ClassWriter writer) throws Exception {
        ClassBuilder builder = new ClassBuilder(configuration);
        builder.configuration = configuration;
        builder.classDoc = classDoc;
        builder.writer = writer;
        if (classDoc.isInterface()) {
            builder.isInterface = true;
        } else if (classDoc.isEnum()) {
            builder.isEnum = true;
            Util.setEnumDocumentation(configuration, classDoc);
        }
        if (containingPackagesSeen == null) {
            containingPackagesSeen = new HashSet();
        }
        return builder;
    }

    public void build() throws IOException {
        this.build(LayoutParser.getInstance(this.configuration).parseXML(ROOT), this.contentTree);
    }

    public String getName() {
        return ROOT;
    }

    public void buildClassDoc(XMLNode node, Content contentTree) throws Exception {
        String key = this.isInterface ? "doclet.Interface" : (this.isEnum ? "doclet.Enum" : "doclet.Class");
        contentTree = this.writer.getHeader(this.configuration.getText(key) + " " + this.classDoc.name());
        Content classContentTree = this.writer.getClassContentHeader();
        this.buildChildren(node, classContentTree);
        contentTree.addContent(classContentTree);
        this.writer.addFooter(contentTree);
        this.writer.printDocument(contentTree);
        this.writer.close();
        this.copyDocFiles();
    }

    public void buildClassTree(XMLNode node, Content classContentTree) {
        this.writer.addClassTree(classContentTree);
    }

    public void buildClassInfo(XMLNode node, Content classContentTree) {
        Content classInfoTree = this.writer.getClassInfoTreeHeader();
        this.buildChildren(node, classInfoTree);
        classContentTree.addContent(this.writer.getClassInfo(classInfoTree));
    }

    public void buildTypeParamInfo(XMLNode node, Content classInfoTree) {
        this.writer.addTypeParamInfo(classInfoTree);
    }

    public void buildSuperInterfacesInfo(XMLNode node, Content classInfoTree) {
        this.writer.addSuperInterfacesInfo(classInfoTree);
    }

    public void buildImplementedInterfacesInfo(XMLNode node, Content classInfoTree) {
        this.writer.addImplementedInterfacesInfo(classInfoTree);
    }

    public void buildSubClassInfo(XMLNode node, Content classInfoTree) {
        this.writer.addSubClassInfo(classInfoTree);
    }

    public void buildSubInterfacesInfo(XMLNode node, Content classInfoTree) {
        this.writer.addSubInterfacesInfo(classInfoTree);
    }

    public void buildInterfaceUsageInfo(XMLNode node, Content classInfoTree) {
        this.writer.addInterfaceUsageInfo(classInfoTree);
    }

    public void buildDeprecationInfo(XMLNode node, Content classInfoTree) {
        this.writer.addClassDeprecationInfo(classInfoTree);
    }

    public void buildNestedClassInfo(XMLNode node, Content classInfoTree) {
        this.writer.addNestedClassInfo(classInfoTree);
    }

    private void copyDocFiles() {
        PackageDoc containingPackage = this.classDoc.containingPackage();
        if (!(this.configuration.packages != null && Arrays.binarySearch(this.configuration.packages, containingPackage) >= 0 || containingPackagesSeen.contains(containingPackage.name()))) {
            Util.copyDocFiles(this.configuration, Util.getPackageSourcePath(this.configuration, this.classDoc.containingPackage()) + DirectoryManager.getDirectoryPath(this.classDoc.containingPackage()) + File.separator, "doc-files", true);
            containingPackagesSeen.add(containingPackage.name());
        }
    }

    public void buildClassSignature(XMLNode node, Content classInfoTree) {
        StringBuffer modifiers = new StringBuffer(this.classDoc.modifiers() + " ");
        if (this.isEnum) {
            modifiers.append("enum ");
            int index = modifiers.indexOf("abstract");
            if (index >= 0) {
                modifiers.delete(index, index + new String("abstract").length());
                modifiers = new StringBuffer(Util.replaceText(modifiers.toString(), "  ", " "));
            }
            if ((index = modifiers.indexOf("final")) >= 0) {
                modifiers.delete(index, index + new String("final").length());
                modifiers = new StringBuffer(Util.replaceText(modifiers.toString(), "  ", " "));
            }
        } else if (!this.isInterface) {
            modifiers.append("class ");
        }
        this.writer.addClassSignature(modifiers.toString(), classInfoTree);
    }

    public void buildClassDescription(XMLNode node, Content classInfoTree) {
        this.writer.addClassDescription(classInfoTree);
    }

    public void buildClassTagInfo(XMLNode node, Content classInfoTree) {
        this.writer.addClassTagInfo(classInfoTree);
    }

    public void buildMemberSummary(XMLNode node, Content classContentTree) throws Exception {
        Content memberSummaryTree = this.writer.getMemberTreeHeader();
        this.configuration.getBuilderFactory().getMemberSummaryBuilder(this.writer).buildChildren(node, memberSummaryTree);
        classContentTree.addContent(this.writer.getMemberSummaryTree(memberSummaryTree));
    }

    public void buildMemberDetails(XMLNode node, Content classContentTree) {
        Content memberDetailsTree = this.writer.getMemberTreeHeader();
        this.buildChildren(node, memberDetailsTree);
        classContentTree.addContent(this.writer.getMemberDetailsTree(memberDetailsTree));
    }

    public void buildEnumConstantsDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getEnumConstantsBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }

    public void buildFieldDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getFieldBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }

    public void buildPropertyDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getPropertyBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }

    public void buildConstructorDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getConstructorBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }

    public void buildMethodDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getMethodBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }
}

