/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.axis;

import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.profiler.charts.axis.TimeMark;

public class TimeAxisUtils {
    public static final int NTHNG_NEEDED = 0;
    public static final int DAY_NEEDED = 1;
    public static final int MONTH_NEEDED = 2;
    public static final int YEAR_NEEDED = 4;
    public static final int STEP_MSEC = 1;
    public static final int STEP_SEC = 2;
    public static final int STEP_MIN = 4;
    public static final int STEP_HOUR = 8;
    public static final int STEP_DAY = 16;
    public static final int STEP_WEEK = 32;
    public static final int STEP_MONTH = 64;
    public static final int STEP_YEAR = 128;
    public static final String TIME_SEC = TimeAxisUtils.createTimeSec();
    public static final String TIME_MSEC = TimeAxisUtils.createTimeMSec(TIME_SEC);
    public static final String TIME_MIN = TimeAxisUtils.createTimeMin();
    public static final String DATE_YEAR = TimeAxisUtils.createDateYear();
    public static final String DATE_MONTH = TimeAxisUtils.createDateMonth(DATE_YEAR);
    public static final String DATE_WEEKDAY_SHORT = "EEE";
    public static final String DATE_WEEKDAY = "EEEE";
    public static final String DATE_YEARMONTH = "MMMM";
    public static final String DATE_SINGLEYEAR = "yyyy";
    public static final String TIME_DATE_FORMAT = "{0}, {1}";
    private static final String PATTERN_CHARS = "GyMwWDdFEaHkKhmsSzZ";
    private static final Map<String, Format> FORMATS = new HashMap<String, Format>();
    private static final Calendar c1 = Calendar.getInstance();
    private static final Calendar c2 = Calendar.getInstance();
    public static final long[] timeUnitsGrid = new long[]{1L, 2L, 5L, 10L, 20L, 50L, 100L, 250L, 500L, 1000L, 2000L, 5000L, 10000L, 15000L, 30000L, 60000L, 120000L, 300000L, 600000L, 900000L, 1800000L, 3600000L, 0x6DDD00L, 10800000L, 21600000L, 43200000L, 86400000L, 604800000L, 2628000000L, 5256000000L, 7884000000L, 15768000000L, 31536000000L, 63072000000L, 157680000000L, 315360000000L};

    public static long getTimeUnits(double d, int n) {
        if (Double.isNaN(d) || d == Double.POSITIVE_INFINITY || d <= 0.0) {
            return -1L;
        }
        for (int i = 0; i < timeUnitsGrid.length; ++i) {
            if (!((double)timeUnitsGrid[i] * d >= (double)n)) continue;
            return timeUnitsGrid[i];
        }
        return timeUnitsGrid[timeUnitsGrid.length - 1];
    }

    public static int getStepFlag(long l) {
        if (l > 15768000000L) {
            return 128;
        }
        if (l > 1209600000L) {
            return 64;
        }
        if (l > 172800000L) {
            return 32;
        }
        if (l > 43200000L) {
            return 16;
        }
        if (l > 1800000L) {
            return 8;
        }
        if (l > 30000L) {
            return 4;
        }
        if (l > 500L) {
            return 2;
        }
        return 1;
    }

    public static int getRangeFlag(long l, long l2) {
        c1.setTimeInMillis(l);
        c2.setTimeInMillis(l2);
        if (c1.get(1) != c2.get(1)) {
            return 4;
        }
        if (c1.get(2) != c2.get(2)) {
            return 2;
        }
        if (c1.get(6) != c2.get(6)) {
            return 1;
        }
        return 0;
    }

    public static String getFormatString(long l, long l2, long l3) {
        int n = TimeAxisUtils.getStepFlag(l);
        int n2 = TimeAxisUtils.getRangeFlag(l2, l3);
        String string = null;
        String string2 = null;
        if (n < 16) {
            string = n > 2 ? TIME_MIN : (n > 1 ? TIME_SEC : TIME_MSEC);
        }
        if (n > 8 || n2 != 0) {
            if (n == 128) {
                string2 = DATE_SINGLEYEAR;
            } else if (n == 64 && n2 < 4) {
                string2 = DATE_YEARMONTH;
            } else if (n == 16 && n2 < 2) {
                string2 = DATE_WEEKDAY;
            } else if (n2 == 4) {
                string2 = DATE_YEAR;
            } else if (n2 == 2 || n > 16) {
                string2 = DATE_MONTH;
            } else if (n2 == 1) {
                string2 = DATE_WEEKDAY_SHORT;
            }
        }
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        return MessageFormat.format(TIME_DATE_FORMAT, string, string2);
    }

    public static String formatTime(TimeMark timeMark) {
        String string = timeMark.getFormat();
        Format format = FORMATS.get(string);
        if (format == null) {
            format = new SimpleDateFormat(string);
            FORMATS.put(string, format);
        }
        return format.format(timeMark.getValue());
    }

    private static String createTimeSec() {
        return ((SimpleDateFormat)DateFormat.getTimeInstance(2)).toPattern();
    }

    private static String createTimeMin() {
        return ((SimpleDateFormat)DateFormat.getTimeInstance(3)).toPattern();
    }

    private static String createTimeMSec(String string) {
        return string.replace("ss", "ss.SSS");
    }

    private static String createDateYear() {
        return ((SimpleDateFormat)DateFormat.getDateInstance(2)).toPattern();
    }

    private static String createDateMonth(String string) {
        try {
            String string2 = string.replace("y", "");
            if (string2.length() == 0) {
                return string2;
            }
            String string3 = string2.substring(0, 1);
            while (string2.length() > 0 && !TimeAxisUtils.isPatternChar(string3)) {
                string2 = string2.substring(1);
                string3 = string2.substring(0, 1);
            }
            int n = string2.length();
            String string4 = string2.substring(n - 1, n);
            while (n > 0 && !".".equals(string4) && !TimeAxisUtils.isPatternChar(string4)) {
                string2 = string2.substring(0, n-- - 1);
                string4 = string2.substring(n - 1, n);
            }
            return string2;
        }
        catch (Exception exception) {
            return "MMM d";
        }
    }

    private static boolean isPatternChar(String string) {
        return PATTERN_CHARS.indexOf(string) != -1;
    }
}

