/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.ConfigurationImpl;
import com.javafx.tools.doclets.formats.html.markup.DocType;
import com.javafx.tools.doclets.formats.html.markup.HtmlDocument;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.RawHtml;
import com.javafx.tools.doclets.formats.html.markup.StringContent;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.javafx.tools.doclets.internal.toolkit.util.DocletConstants;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;

public class SourceToHTMLConverter {
    private static final int NUM_BLANK_LINES = 60;
    private static final Content NEW_LINE = new RawHtml(DocletConstants.NL);
    private static String relativePath = "";

    private SourceToHTMLConverter() {
    }

    public static void convertRoot(ConfigurationImpl configuration, RootDoc rd, String outputdir) {
        if (rd == null || outputdir == null) {
            return;
        }
        PackageDoc[] pds = rd.specifiedPackages();
        for (int i = 0; i < pds.length; ++i) {
            if (configuration.nodeprecated && Util.isDeprecated((Doc)pds[i])) continue;
            SourceToHTMLConverter.convertPackage(configuration, pds[i], outputdir);
        }
        ClassDoc[] cds = rd.specifiedClasses();
        for (int i = 0; i < cds.length; ++i) {
            if (configuration.nodeprecated && (Util.isDeprecated((Doc)cds[i]) || Util.isDeprecated((Doc)cds[i].containingPackage()))) continue;
            SourceToHTMLConverter.convertClass(configuration, cds[i], SourceToHTMLConverter.getPackageOutputDir(outputdir, cds[i].containingPackage()));
        }
    }

    public static void convertPackage(ConfigurationImpl configuration, PackageDoc pd, String outputdir) {
        if (pd == null || outputdir == null) {
            return;
        }
        String classOutputdir = SourceToHTMLConverter.getPackageOutputDir(outputdir, pd);
        ClassDoc[] cds = pd.allClasses();
        for (int i = 0; i < cds.length; ++i) {
            if (configuration.nodeprecated && Util.isDeprecated((Doc)cds[i])) continue;
            SourceToHTMLConverter.convertClass(configuration, cds[i], classOutputdir);
        }
    }

    private static String getPackageOutputDir(String outputDir, PackageDoc pd) {
        return outputDir + File.separator + DirectoryManager.getDirectoryPath(pd) + File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertClass(ConfigurationImpl configuration, ClassDoc cd, String outputdir) {
        if (cd == null || outputdir == null) {
            return;
        }
        try {
            SourcePosition sp = cd.position();
            if (sp == null) {
                return;
            }
            File file = sp.file();
            if (file == null) {
                return;
            }
            FileReader r = new FileReader(file);
            LineNumberReader reader = new LineNumberReader(r);
            int lineno = 1;
            relativePath = DirectoryManager.getRelativePath("src-html/") + DirectoryManager.getRelativePath(cd.containingPackage());
            Content body = SourceToHTMLConverter.getHeader();
            HtmlTree pre = new HtmlTree(HtmlTag.PRE);
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    SourceToHTMLConverter.addLineNo(pre, lineno);
                    SourceToHTMLConverter.addLine(pre, line, configuration.sourcetab, lineno);
                    ++lineno;
                }
            }
            finally {
                reader.close();
            }
            SourceToHTMLConverter.addBlankLines(pre);
            HtmlTree div = HtmlTree.DIV(HtmlStyle.sourceContainer, pre);
            body.addContent(div);
            SourceToHTMLConverter.writeToFile(body, outputdir, cd.name(), configuration);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeToFile(Content body, String outputDir, String className, ConfigurationImpl configuration) throws IOException {
        DocType htmlDocType = DocType.Transitional();
        HtmlTree head = new HtmlTree(HtmlTag.HEAD);
        ((Content)head).addContent(HtmlTree.TITLE(new StringContent(configuration.getText("doclet.Window_Source_title"))));
        ((Content)head).addContent(SourceToHTMLConverter.getStyleSheetProperties(configuration));
        HtmlTree htmlTree = HtmlTree.HTML(configuration.getLocale().getLanguage(), head, body);
        HtmlDocument htmlDocument = new HtmlDocument(htmlDocType, htmlTree);
        File dir = new File(outputDir);
        dir.mkdirs();
        File newFile = new File(dir, className + ".html");
        configuration.message.notice("doclet.Generating_0", newFile.getPath());
        FileOutputStream fout = new FileOutputStream(newFile);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fout));
        bw.write(htmlDocument.toString());
        bw.close();
        fout.close();
    }

    public static HtmlTree getStyleSheetProperties(ConfigurationImpl configuration) {
        File stylefile;
        String parent;
        String filename = configuration.stylesheetfile;
        filename = filename.length() > 0 ? ((parent = (stylefile = new File(filename)).getParent()) == null ? filename : filename.substring(parent.length() + 1)) : "stylesheet.css";
        filename = relativePath + filename;
        HtmlTree link = HtmlTree.LINK("stylesheet", "text/css", filename, "Style");
        return link;
    }

    private static Content getHeader() {
        return new HtmlTree(HtmlTag.BODY);
    }

    private static void addLineNo(Content pre, int lineno) {
        HtmlTree span = new HtmlTree(HtmlTag.SPAN);
        span.addStyle(HtmlStyle.sourceLineNo);
        if (lineno < 10) {
            span.addContent("00" + Integer.toString(lineno));
        } else if (lineno < 100) {
            span.addContent("0" + Integer.toString(lineno));
        } else {
            span.addContent(Integer.toString(lineno));
        }
        pre.addContent(span);
    }

    private static void addLine(Content pre, String line, int tabLength, int currentLineNo) {
        if (line != null) {
            StringBuilder lineBuffer = new StringBuilder(Util.escapeHtmlChars(line));
            Util.replaceTabs(tabLength, lineBuffer);
            pre.addContent(new RawHtml(lineBuffer.toString()));
            HtmlTree anchor = HtmlTree.A_NAME("line." + Integer.toString(currentLineNo));
            pre.addContent(anchor);
            pre.addContent(NEW_LINE);
        }
    }

    private static void addBlankLines(Content pre) {
        for (int i = 0; i < 60; ++i) {
            pre.addContent(NEW_LINE);
        }
    }

    public static String getAnchorName(Doc d) {
        return "line." + d.position().line();
    }
}

